<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2016-12-29 21:45
 */
interface GovernmentDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Government 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param government primary key
 	 */
	public function delete($governmetid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Government government
 	 */
	public function insert($government);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Government government
 	 */
	public function update($government);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByGovernmentname($value);


	public function deleteByGovernmentname($value);


}
?>